function [azi, dip] = cos2dirvec(vec)
% COS2DIR Convert a unit vector direction to a geographic direction.
%   [azi, dip] = cos2dir( vec )
%   cos2dir takes a unit vector: vec, and converts it 
%   to a geographic direction specified by its azimuth (azi) and its dip (or plunge),
%   The geographic convention that north is 0 or 360 degrees is used. 2006
% 
%   Yannick Kremer 2006
%   
%   See also DIR2COS
 
    alpha = vec(1);
    beta = vec(2);
    gamma = vec(3);

    d2r = 180/pi;
%   Create an index vector to differentiate between those points with
%   (alpha<0 and beta>=0) and those with (alpha>=0 and beta<0).
    index = (alpha<0 & beta>=0);

%   Preallocate azi variables
    azi = zeros(size(alpha));
    
    azi(index) = 450 - (atan2(beta(index), alpha(index)) .* d2r);

%   Invert the index, to process the other values:  
    index = not(index);
    azi(index) = 90 - (atan2(beta(index), alpha(index)) .* d2r) ;

    dip = 90 - (acos(gamma) .* d2r);

end